Imports System
Imports System.Reflection
Imports System.IO

'
' Programy pracy automatu gastronomicznego wywouj metody klas implementujcych
' ten interfejs.
'
Public Class FoodProcessorEnvironment
    Implements FoodProcessorEnvironmentIF

    '
    ' Odkrawa plaster okrelonej gruboci.
    ' width - Grubo grubo odkrawanego plastra.
    '
    Public Sub Slice(ByVal width As Integer) _
            Implements FoodProcessorEnvironmentIF.Slice
        '...
    End Sub

    '
    ' Miesza skadniki z okrelon szybkoci.
    ' speed - Szybko szybko mieszania skadnikw.
    '
    Public Sub Mix(ByVal speed As Integer) _
            Implements FoodProcessorEnvironmentIF.Mix
        '...
    End Sub

    '
    ' Waga posiku wyraona w gramach.
    '
    Public ReadOnly Property Weight() As Double _
            Implements FoodProcessorEnvironmentIF.Weight
        Get
            Dim w As Double = 0.0
            '...
            Return w
        End Get
    End Property

    ' Uruchamia program oznaczony dan nazw.
    ' assemblyName - Nazwa nazwa podzespou .NET zawierajcego dany program.
    ' programName - Nazwa nazwa uruchamianego programu.
    Public Sub Run(ByVal assemblyName As String, ByVal programName As String)
        Dim a As System.Reflection.Assembly
        Try
            a = System.Reflection.Assembly.LoadFrom(assemblyName)
        Catch ex As Exception
            ' Nie znaleziono wskazanego podzespou.
            '...
            Return
        End Try ' try
        Dim program As AbstractFoodProcessorProgram
        Try
            program = CType(a.CreateInstance(programName), AbstractFoodProcessorProgram)
        Catch ex As Exception
            ' Prba uruchomienia programu zakoczya si niepowodzeniem.
            '...
            Return
        End Try ' try
        program.Environment = Me
        display(program.Name)
        program.Start()
    End Sub 'Run

    Private Sub display(ByVal s As String)
        '...
    End Sub 'display

End Class 'FoodProcessorEnvironment
